# Обозначения

* [!] Нововведения/New features
* [+] Добавлено/New functions
* [~] Изменено/Changed functions
* [%] Исправление - багфикс/Bugfixes
* [@] Эта информация будет интересна только админам и/или разработчикам
  This information is for administrators and/or developers

[TODO](todo.core_stories.md)
[README](readme.core_stories.md)

# Changelog

* `export` - add to log unprocessed IDs - those not supported by import
* `import` - capabilities wich variables is supported

## #ctv core_stories 0.28

## 2025-12-21 01:55:22 46a253 core_stories 0.27.2

* [%] Fixed issue with `name` introduced to URL params

## 2025-12-21 01:29:57 46a252 core_stories 0.27.1

* [+] Added icon for navbar for Story `new_year_2026`
* [~] Now to play story by name `index.php?page=stories/play&name=story_name` should be called

## 2025-12-21 01:02:53 46a251 core_stories 0.27

* [!] Story Manager
  * Added admin menu item to access Story Manager
    * Direct Url `/index.php?page=admin/stories` 
  * List of all availables Stories - sandboxed and/or published
  * Ability to play published story
  * Ability to play sandboxed story of any user (required AUTH_LEVEL_ADMINISTRATOR at least)

[@] Extended IExternalSystem documentation

## 2025-12-19 23:42:19 46a250 core_stories 0.26.1

* [~] Now if StoryPlayer can't save state - Exception thrown
* [~] Adjusted background color for Story Exceptions in `play` mode

## 2025-12-19 23:00:08 46a249 core_stories 0.26

* [+] Визуализация графа Истории в песочнице
    * Добавлен режим раскраски ребёр по исходящему узлу
        * Все рёбра, исходящие из одного узла, будут покрашены одним цветом
        * Удобно для отслеживания Веток из каждой Сцены
    * Добавлен режим раскраски ребёр по входящему узлу
        * Все рёбра, входящие в один узел, будут покрашены одним цветом
        * Удобно для отслеживания, какие Ветки из каких Сцен приходят в данную Сцену
        * `ВНИМАНИЕ!` Для большей читаемости рёбра будут инвертированы - т.е. стрелочки в этом режиме будут указывать ОТ
          Сцены, на которую совершён переход и К Сцене, С КОТОРОЙ совершён переход

## 2025-12-19 21:36:19 46a248 core_stories 0.25

* [+] Визуализация графа Истории в песочнице
    * Теперь Тупики - узлы, из которых в принципе нет выхода - окрашиваются зелёным цветом
    * Добавлен выбор режимов раскраски: без раскраски и по глубине родительского узла
    * Раскраска по глубине родительского узла - узла, из которого исходит ребро
        * Все рёбра, исходящие от узлов на одном уровне вложения, будут раскрашены одним цветом
        * Цвета ротируются по основным цветам радуги красный-желтый-зеленый-итд
            * Если предыдущий цвет был фиолетовым, то цвета начнутся опять с красного, а линия станет пунктирной
            * С каждой ротацией шаг пунктира будет увеличиваться
        * Удобно для отслеживания глубины Сцен в Истории, потому что mermaid (JS-визуализатор) далеко не всегда
          располагает узлы на одной глубине визуально рядом

## 2025-12-19 19:25:04 46a247 core_stories 0.24.2

* [~] Added link to Story graph on sandbox page
* [~] Now when opening graph page it vertically positioned on graph and centered horizontally

## 2025-12-19 10:09:58 46a245 core_stories 0.24.1

* [+] К корневому объекту добавлено строковое поле `storyVersion`, которое можно использовать для версионирования
  Истории
    * `NB!` Сейчас формат этого поля не проверяется, но рекомендуется использовать https://semver.org/lang/ru/
* [+] Визуализация графа Истории в песочнице
    * Граф теперь рендерится с фиксированным размером шрифта, так что если он слишком большой - то не уменьшается под
      размер экрана

## 2025-12-19 09:19:04 46a244 core_stories 0.24

* [!] Визуализация графа Истории в песочнице
    * По адресу `index.php?page=stories/sandbox/graph` доступен граф связей сцен
    * Просчитываются как прямые переходы через `goto`, так и "запрятанные" в `if`. Поддерживается вложенность `if`
    * Каждый узел графа - это Сцена Истории. Каждая стрелка - переход из одной Сцены в другую через указанную Ветку
        * Здесь и ниже в этом пункте `\n ` означает перенос строки
        * `'ветка'\n goto` на стрелке означает безусловный переход от одной Сцены к другой через ветку с именем "ветка"
        * `'ветка'\n if (условие)\n goto` означает переход, если выполняется условие ("then" в директиве `if`)
        * `'ветка'\n if !(условие)\n goto` означает переход, если НЕ выполняется условие ("else" в директиве `if`)
        * `'ветка'\n if (условие)\n goto` означает переход, если выполняется условие ("then" в директиве `if`)
        * `'ветка'\n if (условие1)\n if (условие2)\n goto` означает цепочку вложенных условий
            * Переход будет совершен только если оба условия истины
            * Так же вместо `if (условие1)` может быть и `if !(условие1)` - если этот переход выполняется в разделе "
              else" соответствующей директивы `if`
            * То же самое верно и для `if (условие2)`
            * И вообще - вложенность условий неограничена, а здесь приведен пример всего двухуровневого `if`
    * Специальный тип узла графа - `TRIGGERS`. Он показывает переходы и их условия от срабатывания глобальных триггеров
    * Если возникла синтаксическая ошибка - попробуйте поменять имена Сцен и Веток
    * Детектируются "висячие" Сцены
        * Сцены, из которых нет ни одного перехода и к которым не ведёт ни одна Ветка, окрашиваются красным
        * Сцены, к которым нет ни одного входа, окрашиваются оранжевым
        * Специальный узел `TRIGGERS` окрашивается синим
            * Вполне нормальна ситуация, когда сцены связаны только с `TRIGGERS` - это не считается ошибкой

## 2025-12-18 13:51:09 46a242 core_stories 0.23

* [+] Теперь директива `goto` полноценно поддерживается в `init` всех блоков
    * ВАЖНО! С `goto` в `init` очень легко поймать бесконечную рекурсию! Используйте этот механизм осторожно!
* [~] Интеграция с внешней системой
    * Добавлена поддержка медалей за разные концовки Истории "СНГ-2026"

## 2025-12-18 07:29:06 46a241 core_stories 0.22

* [~] Интеграция с внешней системой
    * Изменено поведение `import` при запросе `rewards`:
        * В песочнице или в неопубликованной Истории возвращается переменная `rewardsDiable = 1`
            * Отслеживание наград невозможно для неопубликованных Историй, частным случаем которой является песочница
        * Вдобавок к списку наград `reward_XXX` возвращается общее количество наград в переменной `rewardsCount`
            * Позволяет понять, что запрос выполнен успешно - просто пока Герой не получал награды
            * По наличию этой переменной можно понять, что История опубликована и запущена не в песочнице
* [~] Logging - better logging output
* [%] Интеграция с внешней системой
    * [%] Fixed directive `import` not working in sandbox or with unpublished Story
* [@] Code changes
    * Moved out formating code from `Logger`
    * Moved importing code to `ExternalSuperNova`
* [@] Changed versioning pattern to semantic one https://semver.org/

## 2025-12-17 18:43:43 46a238 core_stories 0a21

* [+] Documentation - reformatting, rewriting and linking

## 2025-12-16 13:46:38 46a231 core_stories 0a20

* [!] Интеграция с внешней системой
    * Переписана работа экспортера
        * Добавлено подробное логгирование всех событий, которое работает и в песочнице
            * Таким образом можно смотреть - прошёл запрос к экспортёру на начисление ресурсов и чем всё закончилось
            * Сами ресурсы в песочнице по-прежнему `НЕ НАЧИСЛЯЮТСЯ`!
    * Количество ТМ в одном пакете ограничено 5000
* [~] Playing registered Stories
    * Now you can use registered Story name instead of ID in URL like: `/index.php?page=stories/play&id=new_year_2026`
* [~] Обработка ошибок
    * Теперь перехватываются не только Exception, но и некоторые Fatal error
    * Теперь наличие неизвестных полей в блоке бросает эксепшн, а не просто выводит надпись
* [%] Code
    * Исправлена фатальная ошибка если в Истории отсутствует поле `triggers`

## 2025-12-15 16:10:57 46a230 core_stories 0a19

* [+] Playing registered stories
    * Put your Story into `/files/stories/published/` under separate folder, say `new_year_2026`
    * Register your story in DB, table `xxx_stories` where `xxx` - your game DB prefix
        * Put story name like `new_year_2026` into `name` column. Story name should be unique across whole table
        * Put relative path like `files/stories/published/new_year_2026/` into `path` column
        * Remember you autogenerated `id`. Let it be `2`
    * Now your story can be played by anyone via URL `/index.php?page=stories/play&id=2`
    * ?????
    * PROFIT!

## 2025-12-15 12:30:09 46a225 core_stories 0a18

* [!] Интеграция с внешней системой
    * Директива `export` позволяет выдать внешней системе список именованных выражений
    * Выражения будут вычислены в контексте директивы
    * Внешняя система сама решает, что делать с этими данными
    * Могут быть экспортированы переменные любого типа
    * `ВАЖНО!` В песочницах директива `export` не работает!
    * СН ожидает объект со следующими полями:
        * "rewardId" - строка, опционально
            * Применяется для идентификации пакета и отслеживания получения наград игроком СН
            * Максимальная длина - 32 символа. Более длинные строки будут обрезаны до 32 символов
            * Один и тот же "rewardId" может быть использован для пакетов в разных местах Истории
                * В таком случае, игрок получит только первую награду, до которой он дойдёт в ходе Истории
            * Если "rewardId" отстутствует, то считается пустой строкой
            * Рекомендуется использовать в "rewardId" только разрешенные символы переменных ДИ [A-Za-z0-9_]
        * "units" - объект, опционально
            * Имя поля объекта - ID юнита СН
            * Выражение - количество юнитов, который получит игрок СН
            * Поддерживаются следующие ID юнитов:
                * 2499 - Медаль за первое прохождение квеста СНГ-2026
                    * Будет начислена только если еще не существует у игрока
                * 905 - Тёмная Материя
                * Планетарные ресурсы. Будут начислены на Столицу игрока:
                    * 901 - металл
                    * 902 - кристалл
                    * 903 - дейтерий
                * ID корабля, включая расовые и эвентовые
                    * Будут начислены на Столицу игрока
                * ID кусочка паззла из хайспотов "Поиски Торта" и "Сбор Йолочки"
                    * Доступны только если сейчас активен Фестиваль с каким-либо из этих хайспотов
                    * Хайспот тоже должен быть активен
                    * UNIT_EVENT_CHRISTMAS_TREE = 3002
                    * UNIT_EVENT_CHRISTMAS_TOP = 3003
                    * UNIT_EVENT_CHRISTMAS_ELECTRO = 3004
                    * UNIT_EVENT_CHRISTMAS_GARLAND = 3005
                    * UNIT_EVENT_CHRISTMAS_RAIN = 3006
                    * UNIT_EVENT_CHRISTMAS_DECORATION = 3007
                    * UNIT_EVENT_CHRISTMAS_SERPENTINE = 3008
                    * UNIT_EVENT_CHRISTMAS_CONFETTI = 3009
                    * UNIT_EVENT_CHRISTMAS_FIRECRACKER = 3011
                    * UNIT_EVENT_CHRISTMAS_SWEET = 3012
                    * UNIT_EVENT_CHRISTMAS_CHINESE = 3013
                    * UNIT_EVENT_SUPERBORN_CAKE = 3021
                    * UNIT_EVENT_SUPERBORN_CANDLE = 3022
                    * UNIT_EVENT_SUPERBORN_BOOTSTRAP = 3023
                    * UNIT_EVENT_SUPERBORN_GUIDE = 3024
                    * UNIT_EVENT_SUPERBORN_CLASS = 3025
                    * UNIT_EVENT_SUPERBORN_MODULE = 3026
                    * UNIT_EVENT_SUPERBORN_TEMPLATE = 3027
                    * UNIT_EVENT_SUPERBORN_FUNCTION = 3028
                    * UNIT_EVENT_SUPERBORN_CONSTANT = 3029
                    * UNIT_EVENT_SUPERBORN_XNOVA = 3030
                    * UNIT_EVENT_SUPERBORN_DOC = 3031
                    * UNIT_EVENT_SUPERBORN_CHANGELOG = 3032
                    * UNIT_EVENT_SUPERBORN_HELLOWORLD = 3033
                    * UNIT_EVENT_SUPERBORN_SCREENSHOT = 3034
                    * UNIT_EVENT_SUPERBORN_UNUSED = 3035
                    * UNIT_EVENT_SUPERBORN_HACK = 3036
        * ```json
          {
            "export": {
              "rewardId": "'medal'",
              "units": {
                "2499": "finished + 1",
                "905": 1000
              }
            }
          }
          ```
            * Директива просит СН начислить текущему игроку медаль за прохождение Истории (если "finished" != -1) и 1000
              ТМ
* [+] Directive `import`
    * Поддерживаются следующие переменные в запросе:
        * `userName` - имя текущего пользователя СН
        * Три переменные ниже могут быть использован для масштабирования наград:
            * `userRank` - ранг текущего игрока СН
                * Так же может применяться для закрытия части Истории/наград в зависимости от развития игрока
                * Например, можно добавить дополнительные награды для начинающих игроков
                * Или наоборот - закрыть от них часть Истории ради реиграбельности/интриги/из вредности
            * `serverBaseProductionRate` - базовая скорость добычи ресурсов сервера
            * `rewardScale` = `userRank` * `serverBaseProductionRate`
            * Рекомендуется ориентировать награды для скорости добычи x1 и начинающего игрока, а затем масштабировать их
              под текущие настройки сервера и силу игрока, умножая награду на `rewardScale`
                * Рекомендуется масштабировать награды кораблями и планетарными ресурсами (металл, кристалл, дейтерий)
                * Не рекомендуется масштабировать количество ТМ в награде
        * `capitalPlanetName` - название Столицы игрока
        * `capitalPlanetCoords` - координаты Столицы игрока в виде `[G:S:P]`
        * `rewards` - список наград, полученных игроком в ходе данной Истории
            * Для каждой полученной награды будет создана отдельная переменная вида `reward_XXX`, где XXX - имя
              использованное в `rewardId` при экспорте данных. Её значение будет число `1`
            * Именно поэтому рекомендуется использовать в `rewardId` те символы, которые будут понятны ДИ в имени
              переменной
            * ```json
              {
                "export": {
                  "rewardId": "'medal'",
                  "units": {
                    "2499": "1"
                  }
                },              
                "import": [
                  "rewards"
                ]
              }
              ```
                * После выполнения этих директив появится глобальная переменная `reward_medal` со значением `1`
                * По значению этой переменной можно определять - получил ли игрок уже данную награду и, например,
                  отключать Ветки, в которых выдаётся эта награда
* [~] Formulas
    * Now Formulas also can be an object
        * Field names of object can be used to identify separate Formula
* [~] Expressions
    * Now Expressions also can be an object
        * Field names of object can be used to identify separate Expression
    * Now Expressions also can be an array
        * Values will be put in zero-based array
    * Now Expressions can have another Expressions as sub-expression
        * Works both for `calculateAnd` and `calculate`
* [~] Expression
    * Now `/` operator mathematically rounds operation result
    * Now `/` operator handles zero divisor. Result of division by zero would be also zero

## 2025-12-13 20:03:40 46a215 core_stories 0a17

* [+] Documentation
    * "Очень простая История"
    * Заменил отметку имен переменных с '`' на '"'

## 2025-12-13 04:09:56 46a214 core_stories 0a16

* [+] Documentation
    * Переписан раздел "Сцена"
    * Переписан раздел "Ветка"
* [~] Block - moved `content` to Block level
    * Now `Story`, `Scene` and `Branch` can have `content` field
    * For now only `Scene` uses this field properly
* [~] Expressions
    * Now Expressions can be neither array, neither single Expression
    * I.e. for single Expression you can specify it directly as string instead of warping it in array "[]"
    * It's affects `conditions`, `isVisible` fields
* [~] Formulas
    * Now Formulas can be neither array, neither single Expression (see above)
    * It's affects `set` and `state` directives
* [~] Rewrote `story.json` according to new features
* [@] Fixed namespace changes

## 2025-12-12 16:13:14 46a213 core_stories 0a15

* [+] Documentation
    * Переписан раздел "История"

## 2025-12-12 15:37:52 46a212 core_stories 0a14

* [+] Documentation
    * Переписан вводный раздел
    * Добавлен раздел с объяснением формата JSON

## 2025-12-12 11:59:10 46a211 core_stories 0a13

* [~] Sandbox
    * Now if critical error happens while playing Sandbox story then SN returns to Sandbox and display error message
* [~] StoryPlayer
    * Now if critical error happens while playing story then SN display error message
* [@] Added check for save-state file exist

## 2025-12-11 22:02:58 46a208 core_stories 0a12

* [!] Sandbox
    * Добавлена `Песочница игрока` aka `sandbox` - раздел, где каждый игрок может загрузить свою Историю и отладить её
    * Песочница вмещает одну Историю и уникальна для каждого игрока
        * Только игрок имеет доступ к своей песочнице
    * Файловый менеджер песочницы доступен по адресу `/index.php?page=stories/sandbox`. Файловый менеджер:
        * Позволяет загружать файлы Истории в песочницу
            * Поддерживается загрузка нескольких файлов одновременно
            * Загружаемые файлы с компьютера игрока без подтверждения заменят собой файлы в песочнице
        * Позволяет просматривать список файлов в песочнице и производить базовые операции:
            * просмотр
            * скачка
            * удаление
        * Список файлов сортируется по приоритету: сначала - каталоги, затем - JSON-файлы, затем - CSS-файлы и потом -
          все остальные
            * Файлы с одинаковым приоритетом сортируются в алфавитном порядке
        * Скачка и просмотр JSON-файлов запрещёны из соображений безопасности
        * В песочницу можно загружать файлы типов `json, css, webp, png, jpg, jpeg, gif`
        * Файл Истории должен называться `story.json` - с точностью до регистра символов
    * После загрузки хотя бы файла Истории `story.json` можно запустить историю в плеере по адресу
      `/index.php?page=stories/sandbox/play`
    * Текущее состояние Истории сохраняется в файле `story_of_X.json`, где X - число
        * Если нужно сбросить состояние Истории до её финала этот файл нужно удалить
* [@] Moved classes/files to namespace/folder `SuperNovaWs\Stories`

## 2025-12-10 21:51:29 46a207 core_stories 0a11

* [@] Renamed CSS/image files of example story

## 2025-12-10 21:40:12 46a206 core_stories 0a10

* [@] GIT - removed unused files

## 2025-12-10 21:36:05 46a205 core_stories 0a9

* [!] Block - `css` field support
    * Добавлена поддержка поля `css`
    * Поле `css` теперь может быть как в `Story`, так и в `Scene`
    * Поле содержит имя файла стилей CSS, находящегося в каталоге Истории
        * Файл обязан иметь расширение `.css` - строчными буквами - иначе он не будет подключён
        * Файл обязан быть просто именем файла - относительные пути не поддерживаются
        * Поддерживаются `.min.css` файлы - минифицированные CSS-файлы
            * Стиль `style.css` будет подгружен если есть хотя бы один файл - `style.css` и/или `style.min.css`
            * Рекомендуется загружать на сервер сразу минифицированные версии файлов - если есть такая возможность
    * Стили, указанные в CSS-файле будут применены 'as-is' КО ВСЕЙ ИГРЕ! Поэтому - будьте аккуратны!
        * С другой стороны - это позволит изменять внешний вид игры при необходимости
    * Если поле `css` не найдено в Сцене, оно будет взято из Истории
        * Что бы запретить брать файл стиля из Истории, нужно использовать `null`:
        * ```json
          {
            "css": "story.css",
            "scenes": {
              "sceneWitOwnCss": {
                "css": "scene.css",
                "comment": "This scene will use own style from `scene.css`. You can use `\\@import` directive in CSS file to include other CSSs"
              },
              "sceneWithStoryCss":  {
                "comment": "When `css` is not present or empty (equal to '') CSS from Story will be used"
              },
              "sceneWithoutCss":  {
                "css": null,
                "comment": "`null` - without quotes - as `css` field value will instruct to not use Story's CSS"
              }
            }
          }
          ```
* [!] Block - `image` field support
    * Добавлена поддержка поля `image`
    * Поле `image` может быть в блоках `Story` и `Scene`
    * Поле содержит имя файла с изображением, находящегося в каталоге Истории
        * Файл обязан иметь одно из расширений `webp`, `png`, `jpg`, `jpeg`, `gif` - строчными буквами - иначе он не
          будет подключён
        * Файл обязан быть просто именем файла - относительные пути не поддерживаются
    * Если поле `image` не найдено в Сцене, оно будет взято из Истории
        * Что бы запретить брать файл стиля из Истории, нужно использовать `null`:
    * Изображение будет вставлено в блок `story_scene_image` Сцены при помощи HTML-тэга `img`
        * Управлять его свойствами можно через CSS-стиль `.story_scene_image > img`

## 2025-12-09 09:49:52 46a203 core_stories 0a8

* [!] Directives
    * Новая директива `if`
        * `conditions` - условие: массив выражений, которые нужно вычислить и сложить через "логический И"
            * Если хоть одно из выражений ложно (вычисляется в логический 0) - то условие в целом ложно
        * `then` - директивы, которые нужно выполнить если условие истинно
        * `else` - директивы, которые нужно выполнить если условие ложно
    * Настройка Истории `triggers` теперь используют данную директиву
* [@] Улучшен вывод отладочной информации

## 2025-12-09 08:15:20 46a202 core_stories 0a7

* [!] Поддержка строковых значений переменных
    * Теперь локальным и глобальным переменным можно присваивать строковые значения
        * Допускается только операция присваивания! Другие операции не поддерживаются!
    * Строка определяется как последовательность символов, окруженная одинарными кавычками `'`
    * Допускается инлайн-конкатенация - т.е. указания имени переменной внутри строкового значения, как при рендеринге
      строк. Можно указывать как переменные с целыми значениями, так и со строковыми
    * Символ одинарных кавычек `'`, символ `\` и оператор взятия значения переменной `@` надо экранировать символом `\`
    * Помните про экранирование в JSON!
    * Пример:
        * ```json
          {
            "set": [
              "var1 = 'value'",
              "var2 = '!@var1!'",
              "var3 = '\\@var1'"
            ]
          }
          ```
        * В результате переменные будут содержать:
            * `var1` - строку 'value' без кавычек
            * `var2` - значение переменной `var1`, окруженное восклицательными знаками т.е. '!value!'
            * `var3` - строку '@var1': '\\' из JSON при парсинге превратиться в символ `\`, а `\@` будет
              интерпретировано движком как `символ @`
    * В логических выражениях если строковая переменная содержит число, то оно будет сравниваться как число! Пример:
        * ```json
          {
            "set": [
              "stringWithZero = '0'"
            ],
            "isVisible": [
              "'@stringWithZero'"
            ]
          }
          ```
        * В этом примере условие `isVisible` будет вычислено как логический 0! Имейте это ввиду!
* [+] Directives
    * Отключена сортировка директив по типам. Теперь они исполняются в порядке появления в блоке директив
    * Директива `break` переименована в `exit` для большего соответствия логике работы
    * Теперь блок директив может быть массивом директив. Это позволяет использовать несколько одинаковых директив в
      одном
      блоке. В частности, это позволяет проводить сложные вычисления с использованием локальных и глобальных переменных
        * ```json
          {
            "init": [
              {
                "set": [
                  "color = 'yellow'"
                ]
              },
              {
                "import": [
                  "userName"
                ]
              },
              {
                "set": [
                  "userName = '<span style=\"color: @color;\">@userName</span>'"
                ]
              }
            ]
          }
          ```

## 2025-12-09 05:24:58 46a201 core_stories 0a6

* [!] Рендер переменных в строках
    * Теперь если в текстовой строке написать `@varName` то в это место будет подставлено значение локальной переменной
      `varName`
    * Для вставки символа `@` в текст используйте `\@`. Помните про экранировку символа `\` в JSON:
        * ```json
          {
            "value": "Value of @variable and name of \\@variable - remember about JSON screening!"        
          }
          ```
    * Работает в Block::title, Story::content
* [!] Интеграция с внешней системой
    * Директива `import` позволяет запросить у внешней системы список значений переменных
    * Внешняя система сама решает, какие переменные отдавать, а какие - нет
    * Переменные импортируются на уровне контекста директивы
    * Могут быть импортированы переменные любого типа, но автор Истории должен сам следить за возможностью их
      корректного использования
        * Безопасны к импорту целые числа
        * Могут вызвать нюансы переменные с плавающей запятой
        * Импорт строк рекомендуется использовать только для дальнейшего вывода в тексте
* [~] Обновлен `story.json` для демонстрации новых возможностей
