# **Модуль "Истории"**

[changelog](changelog.core_stories.md)

# Что это такое?

`Движок Историй` (`ДИ`) позволяет воплотить в жизнь текстовые квесты с ветвлениями путём создания Историй.

[`История`](#история) состоит из набора [`Сцен`](#сцена). Переход между Сценами осуществляется `Героем` Истории выбором
одной из доступных в Сцене [`Веток`](#ветки).

Ветки могут быть видимы всегда или иметь определенные [`условия`](#условия) видимости.
Если в текущей Сцене не доступна для выбора ни одна из Веток (то ли по причине их отсутствия, то ли по причине
недоступности из-за невыполнения Условий видимости) - такая Ветка считается `тупиком`.
Если Игрок попадает в Тупик - История считается законченной.
В Тупике можно только начать прохождение Истории заново.

История может отслеживать [`переменные`](#переменные).
Переменные могут использоваться для разных целей: хранение количества какого-то ресурса в игре (например - топлива),
состояние игрока (например - количество жизни и/или маны), состояния самой Истории (например - посещал Герой или
нет определённые Сцены или какие именно Ветки он выбирал по ходу игры).

[`Условия`](#условия) позволяют сравнивать переменные с числовыми значениями и между собой.

[`Формулы`](#формулы) позволяют совершать над числовыми переменными логические и арифметические операции, присваивая
результаты той же или другой переменной.

[`Директивы`](#директивы) инструктируют ДИ производить определенные действия.
Например, директива [`goto`](#goto) указывает движку переключить сцену, а директива [`if`](#if) - вычислить условия и в
зависимости от результата вычислений произвести те или иные действия.

А теперь поподробнее обо всём этом...

# Story unfolds...

Физически (насколько это применимо к информации) История описывается в файле [`story.json`](#storyjson).
Кроме этого файла История может содержать CSS-стили и картинки в разных форматах (поддерживаются форматы WebP, PNG, JPEG
и GIF).

Рекомендуется начинать названия файлов со стилями с префикса "css_" - например, "css_danger.css", а названия
изображений - с префикса "image_" - например, "image_danger.png".
В качестве основной части имени файла рекомендуется использовать название Сцены, к которой относится картинка.
Так, если следовать данной рекомандации, два вышеприведенных файла относятся к Сцене "danger".

Впрочем, это лишь рекомендация - главное, что бы имена файлов были правильно прописаны в соответствующих параметрах
Сцены.

## story.json

Основной файл Истории - файл `story.json` в формате JSON.
JSON расшифровывается как JavaScript Object Notation — «Нотация объектов JavaScript»
JSON-afqk является текстовым файлом в кодировке `UTF-8`, описывающим основные блоки Истории, связь между ними и
логическую структуру Истории.

Без понимания этого формата невозможно создание Историй.
Подробно о формате JSON можно прочесть в интернете.
Здесь же очень коротко (не более десяти страниц) дадим только основу, достаточную для создания Историй.

Кто в курсе формата JSON может сразу перейти к нашей [реализации комментариев](#комментарии-в-json) в JSON-файлах.

## Пример JSON-файла:

```json
{
  "parent": null,
  "girl": true,
  "age": 30,
  "height": 1.65,
  "name": "Alice \"Bob\" \\ Paulson",
  "questions": {
    "who": "Is fucking Alice?",
    "where": "Did she live?"
  },
  "attributes": [
    "PHP",
    "JavaScript",
    "Two\nParagraphs",
    -10,
    -1.25,
    false,
    {
      "another": "object"
    },
    [
      "another",
      "array"
    ]
  ]
}
```

## Объекты JSON

Основная структурная единица JSON=файла - это "объект": сущность, объединяющая в себе пары "ключ-значение".

Для обозначения границ объекта используются фигурные скобки `{}`.
Объект может быть пустым и не содержать ни одной пары "ключ-значение".

Как правило, файл JSON описывает один "корневой" объект.
Т.е. JSON-файл начинается с символа `{`, дальше следует перечень пар "ключ-значение" и закрывется файл символом `}`.
Синтаксически верен и файл JSON, содержащий [массив](#массив-json) в качестве корневой сущности, но это не наш случай.

"Ключ" так же называют "полем объекта" или просто "полем".
В рамках данного документа эти понятия - идентичные и взаимозаменяемые.

Ключ - строка символов, заключённых с обеих сторон в двойные кавычки `"`.
Значение отделяется от ключа символом двоеточия ":".
Значение не может отсутствовать! Т.е. конструкция `"field1":` является ошибочной!

Если в объекте больше одной пары "ключ-значение", то их перечисляют через символ запятой `,`.
После последней пары запятую не ставят - это считается синтаксической ошибкой и приводит к ошибке обработки всего
JSON-файла.

Технически допускается в одном объекте иметь больше одного поля с идентичным именем.
Практически - не рекомендуется это делать, потому что в стандарте JSON поведение при разборе таких файлов неопределено.
Т.е. в зависимости от реализации парсеры JSON могут вести себя по-разному.
Наиболее типичное поведение (в том числе - и в PHP): каждое следующее значение в файле перезаписывает итоговое значение
соответствующего поля.
Фактически берётся последнее из значений.
Однако - это не гарантированное поведение и в других реализациях может как браться первое значение, так и вообще
выдаваться ошибка парсинга.

В [примере выше](#пример-json-файла) мы имеем глобальный JSON-объект с ключами "parent", "name", "age", "height",
"girl", "questions" и "attributes".

При этом все поля в корневом объекте имеет разный `тип значения`.

## Типы значений JSON

JSON поддерживает несколько типов значений

### Тип `null`

`null` - "значение отсутствует".

* Образует собственный тип для того, что бы отличать "значение отсутствует" от "пустой строки" (`""`) или "нуля" (`0`).
* В [примере выше](#пример-json-файла) поле "parent" имеет тип `null`

### `Логический` или `булевский` тип

`Логический` или `булевский тип`

* Возможные значения - `true` и `false` - соответственно логические "истина" и "ложь".
* В [примере](#пример-json-файла) поле "girl" имеет логический тип и его значение равно `true` ("истина")

### `Целочисленный` тип

Десятичное число.

* Поддерживаются отрицательные числа.
* [Выше](#пример-json-файла) поле "age" имеет целочисленный тип и значение `30`

### `Число с фиксированной точкой`

`Фиксированный` или `число с фиксированной точкой` - число с десятичной дробью.

* [В примере](#пример-json-файла) поле "height" имеет фиксированный тип и значение `1.65`
* `ВАЖНО!` Целая и дробная часть такого числа разделяются символом `.` - что отличается от разделителя во многих
  странах!

### `Строковый` тип

Строка текста.

* Набор символов, ограниченный символом двойных кавычек `"`.
* Если нужно включить символ двойных кавычек - перед ним ставят символ обратного слэша `\` вот так: `\"`
    * Еще говорят, что "символ `"` экранируют символом `\"`
* Точно так же для включения символа `\` его экранируют им же самим: `\\`
* В процессе чтения JSON символ экранирования `\` будет удалён и в итоговой строке останется только экранируемый
  символ
* Поэтому итоговое значение поля "name" [в примере](#пример-json-файла) будет НЕ `Alice \"Bob\" \\ Paulson`, а
  `Alice "Bob" \ Paulson`!
* Еще есть символ `\n`, означающий "перевод строки". Он говорит о том, что следующие за ним символы нужно начинать с
  новой строки
* Здесь приведены лишь базовые сведения о строках в JSON, достаточные для написания Истории. Узнать больше вы
  сможете в интернете

`ВАЖНО!` Следует понимать, что даже если строка выглядит внутри как значение другого типа - она всё равно остаётся
строкой! Пример:

```json
{
  "bool": true,
  "null": null,
  "boolStr": "true",
  "nullStr": "null"
}
```

* Поле "bool" имеет [логический тип](#логический-или-булевский-тип) и значение `true`
* Поле "null" имеет тип [`null`](#тип-null) и значение `null`
* Поле "boolStr" имеет [строковый тип](#строковый-тип) и значение "строка, состоящая из символов `t`,`r`,`u` и `e`"
* Поле "nullStr" так же имеет [строковый тип](#строковый-тип) и значение "строка, состоящая из символов `n`,`u`,`l` и
  `l`"

### Объект JSON

`Объект` - задание под-объекта со своими полями/значениями в качестве поля основного объекта.

* В [заглавном примере](#пример-json-файла) поле "questions" является объектом и в свою очередь содержит поля "who" и "
  where" с соответствующими значениями

### Массив JSO  N

`Массив` - список значений без привязки к ключам

* Список значений массива ограничивается квадратными скобками "[]"
* Значения отделяются друг от друга через запятую
* Значения в массиве могут быть любых допустимых типов
* Допускаются пустые массивы без значений
* В [примере выше](#пример-json-файла) "attributes" - массив значений различных типов

`NB!` Это интересно, но сложно и может не пригодиться:

* С формальной точки зрения массив - это специальный вид объекта, чьи ключи - последовательность целых чисел,
  начиная с нуля
* С технической точки зрения массив JSON во многих языках программирования рассматривается как
  `zero-based indexed array`
* С практической точки зрения это означает, что у первого значения массива ("PHP" в примере) ключ (или как
  говорят в таких случаях - "индекс") - число 0, у второго ("JavaScript") - индекс 1 и так далее

## Комментарии в JSON

Сам по себе формат JSON не поддерживает комментарии - все строки в файле являются значимыми.

Однако, поскольку История может достигать огромных размеров и некоторые места могут нуждаться в объяснениях для
других/памятке для автора, ДИ поддерживает комментарии в объектах всех уровней через специальное поле "comment".

При загрузке Истории из КАЖДОГО объекта будет удалено поле "comment", поэтому не следует использовать его в качестве
названий Сцен, Веток и так далее. И вообще - для чего бы то ни было, кроме как комментариев от автора.

Поскольку поле "comment" никак не обрабатывается и видно только автору, тип этого поля может быть любым, допустимым в
JSON. Однострочные комментарии удобно писать одной строкой, а многострочные - массивом строк:

```json
{
  "comment": "Комментарий из одной строки в корневом объекте",
  "scenes": {
    "comment": "Комментарии можно размещать буквально в любом объекте JSON",
    "start": {
      "comment": [
        "Многострочный комментарий",
        "В стартовой сцене"
      ]
    }
  }
}
```

# Основные части Истории

Зная формат JSON можно перейти к описанию блоков Истории в данном формате.

## История

Файл `story.json` является основным файлом описания Истории.
Достаточно иметь только его, что бы начать прохождение Истории Героем.

Корневой объект этого файла является репрезентацией Истории. Его поля называются "параметрами Истории".

Параметры могут быть "обязательными" (их отсутствие приведёт к провалу загрузки Истории из файла) и "опциональными" -
наличии которых не обязательно.

Порядок параметров не имеет значения, однако рекомендуется придерживаться нижеприведенного порядка.
Список параметров Истории (с указанием типа и обязательности):

* "signature" - строковый, обязательно.
    * Всегда "Stories from SuperNova".
    * Используется движком для идентификации файла конфигурации Истории
* "version" - целочисленный, обязательно.
    * Версия формата Истории.
    * Пока всегда `1`
* "debug" - булевский, опционально.
    * Если равен "true" - включается внутренний режим отладки Истории.
* "init" - [`директивы`](#директивы), опционально.
    * Список директив, которые исполняются каждый раз при `старте Истории`
* "title" - строковый, обязательно.
    * Заголовок Истории
* "content" - строка или массив строк, опционально.
    * Краткое описание Истории
* "comment" - любой, опционально.
    * Комментарий разработчика для себя.
    * Не будет обработан движком.
* "image" - строковый, опционально.
    * Имя файла с изображением, которое будет использовано в отсутствии изображения в Сцене
* "css" - строковый, опционально.
    * Имя файла со стилями CSS, который будет использован в отсутствии стиля в Сцене
* "triggers" - [`директивы`](#директивы), опционально
    * Список директив, которые будут исполняться каждый раз при `активации каждой Сцены`
* "scenes" - объект, обязательно
    * Список [`Сцен`](#сцена)
    * Название полей этого объекта являются названиями Сцен, а значения - описанием самих Сцен
    * Обязательно должна быть Сцена с названием "start" - именно с неё всегда начинается История
    * `ВАЖНО!` Названия Сцен являются регистрозависимыми!
      Т.е. "Branch", "brancH" и "branch" - это три разных названия трёх разных Сцен.

`ВАЖНО!` Кроме простых JSON типов выше и далее указываются встроенные типы Истории, типа [`директивы`](#директивы) или
[`условия`](#условия).
Далее примеры будут включать минимальное использование этих типов.
Если примеры будут непонятны интуитивно - при первом чтении их можно пропустить.
Подробнее об этих и других встроенных типах будет рассказано далее.

Поля "title" и "content" могут содержать значения [`переменных`](#переменные) в соответствии с `правилами поиска`.

### Пример минимального файла Истории

```json
{
  "signature": "Stories from SuperNova",
  "version": 1,
  "title": "История из одной Сцены",
  "scenes": {
    "start": {
      "title": "Сцена первая. Она же - единственная",
      "content": "Тупик. История закончилась едва начавшись"
    }
  }
}
```

## Сцена

Основная единица нарратива Истории - "Сцена". Не в смысле "сцена театра", а в смысле "короткая разыгранная сценка".

Поле "scenes" Истории включает в себя одно или несколько именованных описаний Сцен в виде JSON-объекта.
Он может содержать следующие поля:

* "init", "title", "content", "comment", "image", "css" - назначение этих полей аналогичны соответствующим полям Истории
    * "init" - директивы в этом поле исполняются при активации Сцен - т.е. либо после запуска Истории, либо после
      переключения Сцен
    * "image", "css" - если эти поля отсутствуют или пустые (т.е. значение "пустая строка" `""`) - их значение будет
      взято из соответствующих полей Истории.
        * Что бы запретить брать картинку или стили из Истории, нужно этим полям присвоить значение [`null`](#тип-null):
        * ```json
          {
            "scenes": {
              "start": {
                "title": "First Scene",
                "content": "Impasse. Story ends here",
                "image": null,
                "css": null,
                "comment": "This Scene will not have any image or style attached"
              }
            }
          }
          ```
        * `ВАЖНО!` Для каждой сцены CSS загружается ОТДЕЛЬНО! Поэтому если в сцене вы хотите использовать какие-то общие
          стили - используйте директиву CSS `@import` внутри файла стилей!
* "branches" - объект, опционально. Может быть пустым.
    * Список возможных выборов Героя в данной Сцене - [`Веток`](#ветки)
    * Ветки могут иметь условия видимости
    * Если в текущий момент ни одна Ветка не видима или список веток отсутствует/пустой - эта Сцена является Тупиком и
      История считается завершенной

## Ветки

`Ветка` (или более полно "Ветка развития Истории") предоставляет Герою возможность совершить выбор развития Сцены.
Может содержать следующие поля:

* "init", "title", "comment" - формат этих полей аналогичны соответствующим полям Сцены
    * "init" Ветки выполняется после "init" родительской Истории - см. [`порядок событий`](#порядок-событий)
* "isVisible" - [`условия`](#условия), опционально.
    * Если условие "isVisible" истинно, или отсутствует, или пустое - ветка видна
    * Если ложно - ветка не видна
    * Если количество всех видимых веток после вычисления всех условий "isVisible" равно нулю - Сцена считается Тупиком
* "onChoice" - [`директивы`](#директивы), опционально.
  Директивы, которые будут выполнены при выборе Героем данной Ветки Истории.

Простой пример:

```json
{
  "flight": {
    "title": "Flying!",
    "branches": {
      "jump": {
        "init": [
          "aTemperature = temperature + 10",
          "aDistance = distance + 1"
        ],
        "title": "Engine temperature will become @aTemperature, distance to base will become @aDistance",
        "isVisible": "temperature < 120",
        "onChoice": {
          "comment": "Propagating local variables to global ones",
          "state": [
            "distance = aDistance",
            "fuel = aFuel"
          ],
          "goto": "flight"
        }
      }
    }
  }
}
```

Если при входе на эту Сцену `temperature` была 100, а `distance` была 5, то данный вариант выбора будет выглядеть как
`Engine temperature will become 110, , distance to base will become 6`.
Ветка будет доступна для выбора, если изначально `temperature` была менее 110.

Использованные `директивы` и их особенности будут разъяснены ниже.

`NB!` Название веток кодируется при передаче - поэтому спокойно выбирайте удобные названия для веток и не бойтесь
заспойлерить варианты выбора!

### Ветвления со скрытой логикой

С помощью подбора условий в "isVisible" можно скрытно подменять варианты развития событий в зависимости от состояния
Истории.

Примеры реализации скрытой логики в зависимости от состояния Игрока можно посмотреть в
прилагаемой ["Простой истории"](./stories/simple_story/story.json) в сцене "noReturn".

Первый вариант - манипуляция видимостью Веток с одинаковым "title" и непересекающимися условиями "isVisible".
Он реализован при помощи трёх Веток: "afterburnOk", "afterburnShutdown" и "explosion".
Условия видимости Веток подобраны так, что в зависимости от текущего значения "temperature" будет видна только одна
Ветка из трёх.
А поскольку "title" для этих трёх Веток одинаковый - визуально это будет как выбор одной и той же ветки.

Другой вариант - использование сложного условия в "onChoice".
Пример можно посмотреть там же в ветке "afterburnCombined". Отличия от предыдущего варианта:

* Плюс. Эта ветка - всегда видима. Не нужно заморачиваться с условиями в "isVisible"
* Плюс. Общая директива "state" выполнняется один раз сразу для всех вариантов
* Плюс. Вся логика показа конкретного "title" собрана в одном месте
* Минус. Более сложная логика директив сама по себе

В зависимости от потребностей можно выбрать первый или второй вариант

## Очень простая История

Соберём теперь всё вышеизложенное в [очень простую Историю](./stories/very_simple_story/story.json), демонстрирующую
основные блоки:

```json
{
  "signature": "Stories from SuperNova",
  "version": 1,
  "title": "Очень простая История",
  "scenes": {
    "start": {
      "title": "Развилка",
      "content": "Герой стоит на развилке перед камнем. От камня отходят три дороги: налево, прямо и направо",
      "branches": {
        "goLeft": {
          "title": "Пойти налево",
          "onChoice": {
            "goto": "leftRoad"
          }
        },
        "goForward": {
          "title": "Пойти прямо",
          "onChoice": {
            "goto": "forwardRoad"
          }
        },
        "goRight": {
          "title": "Пойти направо",
          "onChoice": {
            "goto": "rightRoad"
          }
        }
      }
    },
    "leftRoad": {
      "title": "Налево пойдёшь - коня потеряешь",
      "content": [
        "Герой свернул на левую дорогу.",
        "Долгое время ничего не происходило и Герой уже начал скучать.",
        "Как ВДРУГ! Герой осознал, что уже некоторое время идёт пешком!",
        "Отряд не заметил потери коня..."
      ],
      "branches": {
        "goLeft": {
          "title": "Обратиться к дружинникам",
          "onChoice": {
            "goto": "callCops"
          }
        }
      }
    },
    "callCops": {
      "title": "Звонок дру...жиннику",
      "content": [
        "Герой катнул яблочко наливное по тарелочке.",
        "Через пару минут ожидания на донышке появилась дружелюбное лицо, едва влезающее в кружочек:",
        "- Вас уже убили? - радостно поинтересовалось лицо. - Нет? Вот когда убьют - приходите!",
        "И изображение пропало.",
        "",
        "Обескураженный Герой попытался сам найти коня. Но крики, цоканье, размахивание яблочком в воздухе не привели ни к какому результату",
        "",
        "А какой же Герой - да без коня? Без коня - он и не Герой. Значит тут и сказке конец, а Герой - не молодец"
      ],
      "comment": "Обратите внимание - можно добавить пустую строку к тексту"
    },
    "forwardRoad": {
      "title": "Пойдёшь прямо - об камень стукнешься",
      "content": [
        "От сильного удара о камень у Героя помутилось в голове и кровь из раны начала заливать глаза.",
        "Какое уж тут приключение - с такой-то дырой в голове! Тут в травму надо срочно скакать!"
      ]
    },
    "rightRoad": {
      "title": "Пойдёшь направо - голову сложишь",
      "content": [
        "Герой свернул направо. Несколько часов ничего не происходило и в конце-концов Героя сморил сон.",
        "Он сложил голову на грудь и задремал. Вот и ладненько. Не будем его будить.",
        "Это - хороший конец Истории..."
      ]
    }
  }
}
```

# Сложные Истории

Простую Историю можно рассказать, пользуясь только базовыми знаниями о синтаксисе и одной [`директивой goto`](#goto).
Для построения Историй со сложной логикой переходов необходимо освоить расширенные возможности ДИ.

Ниже предоставляется справочный материал по концепциям, применяемым в ДИ для реализации Историй практически любой
сложности.

## Переменные

`Переменная` - это значение, которое отслеживается движком Истории по привязанному к нему имени. Таким образом,
используя везде одно и то же имя переменной, движок сможет по нему определять её текущее значение и использовать
его для вычислений.

Имя переменной может включать строчные и прописные буквы английского алфавита, цифры от 0 до 9 и символ подчеркивания
`_`. Имя должно начинаться с буквы. Минимальная длина имени переменной - 1 символ.

Если какая-то переменная еще не объявлена - т.е. ей еще не было присвоено значение - то считается, что её значение равно

0. Учитывайте этот момент во время написания Истории!

В тестовые поля значение переменной можно подставить, используя знак `@`. Например, если у нас есть переменная "fuel" и
её значение равно 10, то текстовое поле "Остаток топлива @fuel единиц" после обработки движокм будет выглядеть как
"Остаток топлива 10 единиц".

### Порядок событий

## Формулы

Формулы позволяют устанавливать и менять значение переменных, производить базовые математические и логические операции,
а так же операции сравнения

В общем виде формула выглядит как "{переменная} = {значение}", где

* `{переменная}` - имя переменной
* `{значение}` - новое значение переменной

Формулы могут объединяться в массивы

## Значения

## Выражения

### Присваивания

Простейшая формула - это операция присвоения, когда `{значение}` является числом. Пример:

```json
  "resource1 = 10"
```

Вышеуказанный пример означает:

* Присвоить переменной `resource1` значение 10

Формулы могут объединяться в цепочки. Тогда они объявляются как JSON-массив строк-формул. Пример:

```json
[
  "resource1 = 10",
  "resource2 = 20"
]
```

Формулы исполняются последовательно сверху вниз. Вышеуказанный пример означает:

* Присвоить переменной `resource1` значение 10
* Присвоить переменной `resource2` значение 20

Чуть более сложная операция присвоения - когда `{значение}` является значением другой переменной. Пример:

```json
[
  "resource1 = 10",
  "resource2 = resource1"
]
```

В данном пример происходит следующее:

* Переменной `resource1` присваивается значение `10`
* Вторая формула означает: `Возьми значение переменной resource1 (т.е. 10) и присвой его переменной resource2`
* Таким переменной `resource2` будет присвоено значение `10`

### Арифметические операции

Движок Историй позволяет производить базовые арифметические операции. Для таких формул `{значение}` выглядят как
`{operand1} {operation} {operand2}`, где:

* `{operand1}` и `{operand2}` могут быть числами или названиями переменных
* `{operation}` может быть одна из операций `+`, `-`, `*`, `/`
    * ВАЖНО! Операция `/` всегда возвращает целочисленное значение, математически округленное до ближайшего целого
        * Т.е. если дробная часть от деления < 0.5 - результат будет округлён вниз. В противном случае результат
          будет округлён вверх

Пример:

```json
[
  "res1 = 10",
  "res2 = 3",
  "plus5 = @res1 + 5",
  "sum = @res1 + @res2",
  "sub = @res1 - @res2",
  "mul = @res1 * @res2",
  "div = @res1 / @res2",
  "sqr = @res1 * @res1",
  "res1 = @sum + @res2",
  "res2 = @res1 + @res2"
]
```

По итогу исполнения этого кода мы будем иметь следующие значения переменных:

* `plus5` = 10 + 4 = 14
* `sum` = 10 + 3 = 13
* `sub` = 10 - 3 = 7
* `mul` = 10 * 3 = 30
* `div` = 10 / 3 = 3,(3) - но вспоминаем про правила математического округления и получаем значение `3`
* `sqr` = 10 * 10 = 100
* `res1` = 13 + 3 = 16 - здесь изменится значения переменной `res1` на `16` и далее именно оно будет использовано в
  вычислениях
* `res2` = 16 + 3 = 19

Пробелы - ВАЖНЫ! Если они указаны в шаблоне формулы - они нужны для корректной работы системы

### Логические операции

* Результат логической операции - всегда либо `0`, либо `1`
    * `0` означает, что заданное выражение ложно
    * `1` означает, что заданное выражение истинно
* Для логических операций не имеет значения фактическое значение переменной - важно только равен он `0` или нет
    * Поэтому зачения `1`, `10`, `-10` будут восприниматься логическими операциями как значение `1`

### Бинарные логические операции

Вид формулы для бинарных логических операции выглядят знакомо `{operand1} {operation} {operand2}`, где:

* `{operand1}` и `{operand2}` могут быть целыми числами или именами переменных
* `{operation}` - одна из операций `&` и `|`
* `&` означает "логическое И" - т.е. если все операнды не равны `0`, то результат операции - `1`. В противном
  случае результат операции `0`
* `|` означает "логическое ИЛИ" - т.е. если хотя бы один из операндов не равен `0`, то результат операции - `1`.
  В противном случае результат операции `0`

* Пример:

```json
[
  "true = 1",
  "alsoTrue = -10",
  "false = 0",
  "trueAndAlsoTrue = true & alsoTrue",
  "trueAndFalse = true & false",
  "trueOrAlsoTrue = true | alsoTrue",
  "trueOrFalse = true | false",
  "falseOrFalse = false | false"
]
```

По итогу исполнения данных вычислений мы будем иметь:

* `trueAndAlsoTrue` = 1 & -10 = 1
* `trueAndFalse` = 1 & 0 = 0
* `trueOrAlsoTrue` = 1 | -10 = 1
* `trueOrFalse` = 1 | 0 = 1
* `falseOrFalse` = 0 | 0 = 0

### Бинарные операции сравнения

А еще бывают бинарные логические операции сравнения `{operand1} {operation} {operand2}`, где:

* `{operand1}` и `{operand2}` могут быть целыми числами или переменными
* `{operation}` может быть одна из операций `<`, `>` или `~`
* `<` возвращает `1` если `{operand1}` меньше `{operand2}`. В противном случае возвращает `0`
* `>` возвращает `1` если `{operand1}` больше `{operand2}`. В противном случае возвращает `0`
* `~` возвращает `1` если `{operand1}` равен `{operand2}`. В противном случае возвращает `0`

Как и для всех логических операций, результатом операций сравнения являются значения `0` или `1`. Например:

```json
[
  "morale = 1",
  "despair = 0",
  "fuel = 0",
  "isDespair = despair < morale",
  "canFly = fuel > 1",
  "canSpendFuel = fuel > 1",
  "noFuel = fuel ~ 0"
]
```

* По итогу исполнения этого кода мы будем иметь:
* `isDespair` = (0 < 1) = 1
* `canFly` = (0 > 1) = 0
* `canSpendFuel` = (0 > 1) = 0
* `noFuel` = (0 ~ 0) = 1

### Унарные логические операции

Унарные логические операции имеют только один операнд `{operation} {operand}`, где:

* `{operand}` - значение или переменная
* `{operation}` - операция `!` (логическое "НЕ")
* Операция `!` действует как логическая инверсия значения переменной
    * Если переменная `res` была равна `0`, то отрицание `res` даст `1`
    * Если переменная `res` была не равна нулю, то отрицание `res` даст `0`

Пример:

```json
[
  "true = 10",
  "negativeTrue = -10",
  "false = 0",
  "notTrue = ! true",
  "notNegativeTrue = ! negativeTrue",
  "notFalse = ! false"
]
```

По итогу исполнения этого кода мы будем иметь:

* `notTrue` = (! 10) = 0
* `notNegativeTrue` = (! -10) = 0s
* `notFalse` = (! 0) = 1

## Директивы

`Директивы` - это указания движку Истории на то, каким образом нужно обрабатывать тот или иной блок данных.

Директивы бывают глобальные - которые влияют на всю Историю - и контекстные - которые влияют только на блок данных,
внутри которого они находятся.

Директивы указываются как ключ перед соответствующим блоком данных.

Директивы могут быть вложенными - т.е. внутри блока данных могут встречаться и другие Директивы.

Некоторые Директивы могут встречаться почти где угодно, а некоторые - могут встречаться только в блоках данных
определенных Директив.

### <a name="state"></a>Вычисление значения глобальных переменных

Сами по себе формулы или даже их цепочки - бесполезны. Пользу им придаёт объявление цепочки формул как Директивы.

Наиболее мощная глобальная Директива в игре - `state`. Она указывает движку, что данные формулы нужно рассматривать как
изменяющие глобальные переменные Игрока. Пример:

```json
{
  "state": [
    "fuel = 10",
    "morale = 10",
    "maxDistance = fuel"
  ]
}
```

Данная Директива установит глобальные значения соответствующих переменных в каком бы блоке и на каком бы уровне она не
находилась, поэтому используйте `state` с осторожностью! В большинстве случаев вместо неё лучше использовать директиву
`set`. Почти всегда нужно использовать `set` в директивах `trigger` и "branches". По большому счёту кроме конфигурации
Истории использование `state` бывает оправдано только в описании Сцен.

### <a name="set"></a>Вычисление локальных переменных

Директива `set` указывает на то, что переменные должны быть вычислены внутри блока, в котором она находится и не должны
менять значения глобальных переменных. Пример:

```json
{
  "config": {
    "state": [
      "a = 10"
    ]
  },
  "scene": {
    "state": [
      "a = a + 1"
    ],
    "set": [
      "b = 20"
    ],
    "title": "В полёте",
    "branches": {
      "branch": {
        "set": [
          "c = b - a",
          "a = a - c"
        ],
        "goto": "scene"
      }
    }
  }
}
```

Хотя `set` не может изменять данные за пределами своего блока, но другие Директивы могут скопировать локальные значения
в глобальные переменные, как и происходит выше с Директивой `goto`. Подробнее этот пример будет
разъяснён [далее](branching)).

`set` проверяет значения переменных "снизу-вверх" по иерархии вложенности, начиная с текущего уровня. Если в блоке
`set` не объявлена некоторая переменная, то `set` сначала проверит своего родителя, затем - его родителя и так до тех
пор, пока значение переменной не будет найдено в локальном пуле вышестоящей директивы или в глобальном списке
переменных. После чего найденное значение будет использовано как стартовое значение локальной переменной в этом блоке.
Если переменная так и не будет найдена, то локальное значение будет установлено в `0`

Поясним это на примере выше.

* Начнём с формулы "c = b - a":
    * Директива `set` внутри блока `branch` устанавливает одну локальную переменную `c`
    * Для этого она использует значение двух других переменных - `b` и `a`, но пока неизвестны их значения
    * Поскольку переменная `b` не была установлена раннее в этом блоке, начинается поиск её значения "вверх" по иерархии
    * Значение `20` переменной `b` будет найдено как значение локальной переменной, установленной ранее в блоке `scene`
    * Переменная `a` так же не была установлена локально и будет попытка найти её выше по иерархии
    * Однако в данном случае ни в одном из блоков не было установлено значение локальной переменной `a`!
    * Соответственно, будет использовано значение глобальной переменной `a`. Но какое оно будет?
        * Изначально в конфигурации Истории значение переменной `a` было установлено в `10`
        * Однако при каждом входе в Сцену Директива `state` блока `scene` увеличивает значение `a` на единицу
        * Пусть это первый вход в Сцену, то значение `a` будет равно `11`
    * Будем считать, что это - первый заход и `a` = `11`
    * Таким образом c = 20 - 11 = 9
* Вторая формула интересней: "a = a - c"
    * Значение `a` = `11` по-прежнему найдётся из локальной переменной в блоке `scene`
    * Локальная переменная `c` в блоке `branch` уже вычислена и равна `9`
    * И хотя переменная `a` у нас есть выше, но мы помним, что `set` не может менять значения за пределами своего блока,
      поэтому вычисление "a = a - c" создаст новую локальную переменную `a` в блоке `branch` и установит её значение в
      `2` (11 - 9)

Очень важно понимать правила работы локальных переменных, что бы не допускать ошибок!

Так же тут важно отметить, что Директива `goto` актуализирует все локальные переменные, скопировав их в глобальные. Т.е.
она установит значение глобальной переменной `a` в `2` и создаст новую глобальную переменную `c` со значением `9`!

### Условия

Директива `conditions` указывает трактовать блок формул как логические условия. Каждая формула вычисляется, результат
вычислений трактуется как логический 0 или логическая 1 и все эти результаты объединяются через "логическое И".

`conditions` следует логике `set` по поиску значения переменной. Однако в отличие от последней, директива `conditions`
не меняет значения локальных переменных. Поэтому данная директива использует сокращённую запись формул: вместо
`c = b > a` используется форма `b > a`. Если вам нужно сохранить результат вычисления - сначала используйте `set`.

Пример:

```json
{
  "set": [
    "morale = -1"
  ],
  "conditions": [
    "morale > 0"
  ]
}
```

Поскольку утверждение `-1 > 0` ложно, то условия считаются невыполненными

Естественно, в `conditions` работает не только сравнение "больше чем", но и все остальные арифметические и логические
операции.

Как было сказано в начале, если формул несколько, то они сочетаются через "логическое И". Т.е если хоть одно условие в
списке провалено - проваливается и весь блок `conditions`. Пример:

```json
{
  "set": [
    "morale = 10",
    "fuel = 0"
  ],
  "conditions": [
    "morale > 0",
    "fuel > 0"
  ]
}
```

* Первое выражение условия `morale > 0` = (10 > 0) - истинно, т.е. даёт нам `1`
* А вот второе выражение `fuel > 0` = (0 > 0) - ложно, т.е. даёт нам `0`
* Соответственно, как мы уже знаем (1 & 0) = 0, т.е. условие не удовлетворено

Для реализации "логического ИЛИ" в условиях используйте цепочки формул в `set`. Пример:

```json
{
  "set": [
    "morale = 10",
    "fuel = 0",
    "optimistic = morale > 0",
    "canFly = fuel > 0",
    "noSuicide = optimistic | canFly"
  ],
  "conditions": [
    "noSuicide ~ 1"
  ]
}
```

* По итогу исполнения этого кода мы будем иметь:
    * `optimistic` = (10 > 0) = 1
    * `canFly` = (0 > 1) = 0
    * `noSuicide` = (1 | 0) = 1
* Соответственно, условие `noSuicide ~ 1` = (1 ~ 1) = 1 - истинно

Директива `conditions` без формул всегда вычисляется как логическая 1.

### if

TODO

### goto

Директива `goto` указывает движку сменить Сцену на указанную

Исполнение `goto` просматривает все блоки по иерархии "вверх" на наличие локальных переменных и все найденные значения
переписывает в глобальные переменные. Если одна и та же локальная переменная есть на разных уровнях, приоритет отдаётся
более близкому к `goto` уровню. Пример:

```json
{
  "state": [
    "a = 1",
    "b = 1",
    "c = 1"
  ],
  "scene": {
    "set": [
      "b = 2",
      "c = 2"
    ],
    "branches": {
      "thrust": {
        "title": "Стандартный импульс двигателя",
        "set": [
          "c = 3"
        ],
        "goto": "continue",
        "comment": "Обычный полёт на 1 единицу"
      }
    }
  }
}
```

При исполнении директивы `goto` глобальные переменные приобретут следующий вид:

* `a = 1` - потому что значение переменной не перекрыли ничем
* `b = 2` - хотя в самой ветке `b` не перезаписывается, оно меняется в сцене (блок `scene`)
* `c = 3` - значения локальной переменной в том же блоке, что и `goto` имеет максимальный приоритет

### <a name="break"></a>Остановка дальнейшей обработки

### <a name="triggers"></a>Триггеры

Глобальные триггеры предназначены для выполнения определенных действий (вычислений, изменения Сцены итд) вне зависимости
от текущей Истории

Глобальные триггеры прописываются в конфигурации `config` директивой "triggers". Содежание директивы - массив,
включающий одно или более описаний триггеров. В каждом описании могут быть следующие поля и директивы:

* `set` - Опционально. Устанавливает значения локальных переменных в конкретном триггере
* `conditions` - Обязательно. Список условий, которые нужно проверить в данном триггере
* `actions` - Обязательно. Список действий, которые нужно проделать в данном триггере, если условия триггера выполнены

Триггеры выполняются последовательно. Если в списке действий текущего триггера нет директив, прерывающих обсчёт, то
выполняются все триггеры. Кстати, о действиях. В списке действий `actions` допустимы следующие директивы:

* `state` - изменить значение глобальных переменных
* `break` - прервать обсчёт текущего и дальнейших триггеров. Может иметь два варианта:
    * `break: 0` - содержимое локальных переменных НЕ БУДЕТ переписано в глобальные
    * `break: 1` - значения глобальных переменных будут заменены локальными значениями
* `goto` - сменить Сцену на указанную. Так же будут заменены значения глобальных переменных на локальные

Глобальные триггеры запускаются при входе на Сцену и ПОСЛЕ выполнения директивы `state`, если она присутствует в Сцене

TODO - СКРЫТЫЕ СЦЕНЫ
TODO - maxStack

Будьте осторожны! Неаккуратное и непродуманное использование директивы `goto` в триггерах может привести к бесконечному
циклу! Например:

```json
{
  "config": {
    "state": [
      "fuel = 2"
    ],
    "triggers": [
      {
        "conditions": [
          "fuel < 1"
        ],
        "goto": "marooned"
      }
    ]
  },
  "start": {
    "title": "Летим!",
    "branches": {
      "fly": {
        "title": "Лететь!",
        "set": [
          "fuel = fuel - 1"
        ],
        "goto": "start"
      }
    }
  },
  "marooned": {
    "title": "Вы проиграли - Топливо закончилось!"
  }
}
```

### Порядок директив

### Последовательность событий при открытии Сцены

## Награды

## Пример Истории

["Простая История"](./stories/simple_story/story.json) демонстрирует основные приёмы создания Историй.

# Локализация

Да, блядь, хотя бы базу сделать!

# TODO

* Разделять Истории по серверам - для мультиинстанса

Порядок отработки ключей:

* Ключ `state` отрабатывается первым в любых комбинациях
* Далее отрабатывается ключ `changes`
* После этого проверяются условия `config.finish`
* И самым последним отрабатывается ключ `conditions`

Так же формулы могут использоваться в разных контекстах. Здесь контекст `state` означает, что формулы используются для
изменения значений Ресурсов.

О контекстах будет рассказано ниже.

, которое может быть числовым значением, значением переменной или вычисляемым
выражением. Об этом будет рассказано подробнее ниже

Ресурсы могут изменятся по формулам. Для этого предназначен

Состояние устанавливают количество определенного Ресурса у Игрока - напрямую или по формуле.

Установка состояния задаётся ключом `state` и выглядит следующим образом:

```json
{
  "state": {
    "resource1": 10,
    "resource2": 20
  }
}
```

Что означает, что

Можно использовать значение другого Ресурса:

```json
{
  "state": {
    "resource1": 10,
    "resource2": "@resource1"
  }
}
```

Что означает, что Ресурс `resource1` выставлен в 10, а `resource2` выставлен в значение Ресурса `resource1`, то есть
теперь тоже равен 10.

// TODO - сделать общий SET в Сценах

Как бы не залупиться!

Встроенные переменные:

* `scene`
* `scene_from`
* `scene_to`

Объект ветвления может содержать следующие ключи:

* "title" - обязательно. Надпись, которая будет выведена как вариант выбора в случае доступности ветки
    * Может содержать ссылки на переменные через конструкцию `@`
    * Приоритет будет отдан локальным переменным - см. правила поиска
    * Содержимое поле "title" может дублироваться среди разных Ветвлений
        * Это позволяет перебрасывать Игрока на разные Сцены в зависимости от выполнения Условий (см. пример ниже)
        * NB! Необходимо внимательно следить за Условиями, что бы они не перекрывали друг друга - иначе в меню выбора
          появятся два одинаковых варианта выбора... Что иногда даже может быть интересно!
* `goto` - обязательно. Указывает, на какую Сцену перейдёт История после выбора данной ветки
* "comment" - опционально. Комментарий разработчика для себя. Не виден Игроку
* `set` - опционально. Устанавливает значения локальных переменных ветки по формулам
    * Если эта ветка будет выбрана через директиву `goto` - все локальные значения будут скопированы в глобальные
      переменные Истории
* `conditions` - опционально. Условия, при которых эта ветка будет доступна в вариантах выбора
    * Что бы ветка появилась в выборах, `conditions` должно вычисляться в логическую "1"

Имя переменной не может содержать символы `@`, `!`, `&`, `|`, `+`, `-`, `*`, `/`, ` `, `(`, `)`, `,`, `<`, `>`, `=`, `~`

Состояние игры

# TODO

http://modules.supernova.local/index.php?page=stories

+ Читает JSON UTF8 как с BOM, так и без неё
+ Теперь любой блок, который является объектом, может содержать "comment"
+ Для апстрима: `variable`:
    + ```json
      {
        "state": [
          "variable = variable"
        ]
      }
      ```
+ `break` => `exit`

* Не обязательно проклацывать всё для достижения сцены - достаточно поменять её в файле

Пример

## My Section Title

Автоматический якорь будет:
#my-section-title

Ссылка на него:
[Go to section](#my-section-title)

* player, игрок => Герой истории

* Упаковать всё в Container

? Убрать директиву `state` - использовать только `upstream`?

* `goto` прерывает исполнение директив, как и `break` - ставьте её последней
* Сортировать директивы при исполнении
    * строгий порядок исполнения директив

* GOTO не должно автоматически экстрактить переменные - только по директиве upstream()

* Не рекомендуется вставлять GOTO в init истории. Делайте историю start

? "Добавить текст к сцене"

? Нужна ли сортировка директив?

* 'import' - вводит данные из внешней системы
* 'export' - выводит данные во внешнюю систему
* Рендер переменных в тексте
* `unset`

+ Ветка "roll" без goto
    + Для демонстрации работы триггеров - глобальный триггер при `random ~ 20` выбьет в критический успех
      ? Валидизация - выдавать предупреждение о возможном тупике

* сделать фасад для стори для использования плеером

* Деление на ноль

* `export` - экспортирует локальные переменные блока в глобальные, заменяя значения последних

# Глоссарий

* `Ключ` - имя поля объекта в JSON.
* `Сцена` - место в Истории, в которой Игрок находится в текущий момент.
* `Массив`
* `Список` - именованный массив
